<?php
session_start();
include 'conexao.php';

// Verifica se o aluno está logado
if (!isset($_SESSION['aluno']) || !isset($_SESSION['aluno']['id'])) {
    header("Location: login_aluno.php");
    exit;
}

$aluno_id = $_SESSION['aluno']['id'];

// Consulta para buscar as notas do aluno em todas as disciplinas
// usando um JOIN para obter o nome das disciplinas
$stmt = $conn->prepare("
    SELECT 
        d.nome AS nome_disciplina,
        n.mt1,
        n.mt2,
        n.mt3,
        n.mfd,
        n.nee,
        n.mf
    FROM notas n
    JOIN disciplinas d ON n.disciplina_id = d.id
    WHERE n.aluno_id = ?
    ORDER BY d.nome
");
$stmt->bind_param("i", $aluno_id);
$stmt->execute();
$result = $stmt->get_result();

$notas_completas = $result->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>PAUTA FINAL DO ALUNO</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f4f6f9;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: #fff;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        h2 {
            text-align: center;
            color: #003366;
            margin-bottom: 25px;
            font-size: 24px;
        }
        .table-responsive {
            overflow-x: auto;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 12px;
            text-align: center;
            white-space: nowrap;
        }
        th {
            background-color: #003366;
            color: white;
            font-weight: 600;
        }
        tbody tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .passou {
            color: green;
            font-weight: bold;
        }
        .reprovou {
            color: red;
            font-weight: bold;
        }
        .voltar {
            display: inline-block;
            margin-top: 25px;
            padding: 10px 20px;
            text-decoration: none;
            color: white;
            background: #003366;
            border-radius: 5px;
            transition: background 0.3s ease;
        }
        .voltar:hover {
            background: #0056b3;
        }
        @media (max-width: 768px) {
            .container {
                padding: 15px;
            }
            h2 {
                font-size: 20px;
            }
            th, td {
                padding: 8px;
                font-size: 12px;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <h2>TERMO DE FREQUÊNCIA E EXAME</h2>
    
    <div class="table-responsive">
        <?php if (!empty($notas_completas)): ?>
            <table>
                <thead>
                    <tr>
                        <th rowspan="2">Disciplina</th>
                        <th colspan="3">Médias Trimestrais</th>
                        <th rowspan="2">MFD</th>
                        <th rowspan="2">NEE</th>
                        <th rowspan="2">MF</th>
                    </tr>
                    <tr>
                        <th>1º Trim. (MT1)</th>
                        <th>2º Trim. (MT2)</th>
                        <th>3º Trim. (MT3)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($notas_completas as $nota): ?>
                        <tr>
                            <td><?= htmlspecialchars($nota['nome_disciplina']) ?></td>
                            <td class="<?= $nota['mt1'] < 10 ? 'reprovou' : 'passou' ?>"><?= number_format($nota['mt1'], 1) ?></td>
                            <td class="<?= $nota['mt2'] < 10 ? 'reprovou' : 'passou' ?>"><?= number_format($nota['mt2'], 1) ?></td>
                            <td class="<?= $nota['mt3'] < 10 ? 'reprovou' : 'passou' ?>"><?= number_format($nota['mt3'], 1) ?></td>
                            <td class="<?= $nota['mfd'] < 10 ? 'reprovou' : 'passou' ?>"><?= number_format($nota['mfd'], 1) ?></td>
                            <td class="<?= $nota['nee'] < 10 ? 'reprovou' : 'passou' ?>"><?= number_format($nota['nee'], 1) ?></td>
                            <td class="<?= $nota['mf'] < 10 ? 'reprovou' : 'passou' ?>"><strong><?= number_format($nota['mf'], 1) ?></strong></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p style="text-align: center;">Nenhuma nota lançada ainda para a sua turma.</p>
        <?php endif; ?>
    </div>
    
    <a href="painel_aluno.php" class="voltar"><i class="fas fa-arrow-left"></i> Voltar</a>
</div>

</body>
</html>